#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

int calculate_happiness(int t, vector<pair<int, pair<vector<int>, vector<int>>>>& test_cases) {
    for (int test = 0; test < t; ++test) {
        int n = test_cases[test].first;
        vector<int> row1 = test_cases[test].second.first;
        vector<int> row2 = test_cases[test].second.second;

        vector<int> prefix_row1(n + 1, 0), prefix_row2(n + 1, 0);

        for (int i = 1; i <= n; ++i) {
            prefix_row1[i] = prefix_row1[i - 1] + (row1[i - 1] % 2);
            prefix_row2[i] = prefix_row2[i - 1] + (row2[i - 1] % 2);
        }

        int max_happiness = 0;

        for (int i = 0; i <= n; ++i) {
            int row1_happiness = prefix_row1[i] + (prefix_row2[n] - prefix_row2[i]);
            int row2_happiness = prefix_row2[i] + (prefix_row1[n] - prefix_row1[i]);

            max_happiness = max(max_happiness, max(row1_happiness, row2_happiness));
        }

        cout << max_happiness << endl;
    }
    return 0;
}

int main() {
    int t;
    int v1=0, v2=0;
    int schastje = 0;
    cin >> t;
    vector<pair<int, pair<vector<int>, vector<int>>>> test_cases;

    for (int i = 0; i < t; ++i) {
        int n;
        cin >> n;
        vector<int> stroka1(n), stroka2(n);

        for (int j = 0; j < n; ++j) {
            cin >> stroka1[j];
        }
        for (int j = 0; j < n; ++j) {
            cin >> stroka2[j];
        }

        vector<int>vihodka;
        for (int e = 0; e < n; e++) {
            stroka1[e] = v1;
            vihodka.push_back(v1);
            stroka2[e] = v2;
            vihodka.push_back(v2);
        }
       

        for (int r = 1; r < n*2; r++) {
            if (vihodka[r] % 2 == vihodka[r-1]%2) {
                schastje++;
            }
        }cout << schastje << endl;
       
    }

   

    return 0;
}